<?php
require_once '../includes/auth.php';
require_once '../config/database.php';

requireLogin();

$basePath = '..';
$userId = $_SESSION['user_id'];

$songId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($songId <= 0) { header('Location: index.php'); exit; }

$song = fetchRow("SELECT * FROM song_sheets WHERE id = ?", [$songId]);
if (!$song) { header('Location: index.php'); exit; }

if ((float)$song['price'] <= 0) {
    header('Location: index.php');
    exit;
}

$purchase = fetchRow("SELECT * FROM song_sheet_purchases WHERE song_sheet_id = ? AND user_id = ? ORDER BY id DESC LIMIT 1", [$songId, $userId]);
if (!$purchase) {
    executeQuery(
        "INSERT INTO song_sheet_purchases (song_sheet_id, user_id, amount, payment_status, created_at) VALUES (?,?,?,?, NOW())",
        [$songId, $userId, (float)$song['price'], 'pending']
    );
    $purchaseId = getLastInsertId();
    $purchase = fetchRow("SELECT * FROM song_sheet_purchases WHERE id = ?", [$purchaseId]);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Purchase Song Sheet - GHAMECC</title>
    <?php include '../includes/favicon.php'; ?>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<?php include '../includes/navbar.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php include '../includes/sidebar.php'; ?>
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <h1 class="h2 mb-3">Purchase Song Sheet</h1>
            <div class="card">
                <div class="card-body">
                    <h4 class="mb-1"><?php echo htmlspecialchars($song['title']); ?></h4>
                    <p class="text-muted">Price: <strong>GH₵ <?php echo number_format($song['price'], 2); ?></strong></p>
                    <p>Status: <span class="badge bg-<?php echo $purchase['payment_status']==='paid'?'success':'warning'; ?>"><?php echo ucfirst($purchase['payment_status']); ?></span></p>
                    <?php if ($purchase['payment_status'] === 'paid'): ?>
                        <a class="btn btn-success" href="../uploads/song_sheets/<?php echo htmlspecialchars($song['file_path']); ?>" target="_blank"><i class="fas fa-download me-1"></i>Download</a>
                        <a class="btn btn-secondary" href="index.php">Back</a>
                    <?php else: ?>
                        <a class="btn btn-primary" href="pay.php?purchase_id=<?php echo (int)$purchase['id']; ?>">Pay Now</a>
                        <a class="btn btn-outline-secondary" href="index.php">Back</a>
                    <?php endif; ?>
                </div>
            </div>
        </main>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</body>
</html>
