<?php
/**
 * Member Dashboard
 * GHAMECC Choir Management Platform
 */

// Include authentication functions
require_once '../includes/auth.php';

// Require login and member role
requireLogin();
requireRole('member');

// Get user information
$userId = $_SESSION['user_id'];
$userFullName = $_SESSION['full_name'] ?? $_SESSION['username'];

// Set base path for includes
$basePath = '..';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Member Dashboard - GHAMECC Choir Management</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Custom CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <!-- Navigation -->
    <?php include '../includes/navbar.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include '../includes/sidebar.php'; ?>
            
            <!-- Main Content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Member Dashboard</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <button type="button" class="btn btn-sm btn-outline-secondary">Share</button>
                            <button type="button" class="btn btn-sm btn-outline-secondary">Export</button>
                        </div>
                    </div>
                </div>
                
                <!-- Welcome Card -->
                <div class="card shadow mb-4">
                    <div class="card-body">
                        <h4>Welcome to the Member Dashboard</h4>
                        <p>As a member, you can view choir events, your attendance records, and manage your profile.</p>
                    </div>
                </div>
                
                <div class="row">
                    <!-- Member Quick Links -->
                    <div class="col-lg-6 mb-4">
                        <div class="card shadow">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">Member Quick Links</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <a href="../profile/view.php" class="btn btn-primary btn-block w-100">
                                            <i class="fas fa-user me-2"></i> My Profile
                                        </a>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <a href="../events/calendar.php" class="btn btn-secondary btn-block w-100">
                                            <i class="fas fa-calendar-alt me-2"></i> Event Calendar
                                        </a>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <a href="../attendance/my-record.php" class="btn btn-info btn-block w-100">
                                            <i class="fas fa-clipboard-check me-2"></i> My Attendance
                                        </a>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <a href="../financial/my-dues.php" class="btn btn-warning btn-block w-100">
                                            <i class="fas fa-money-bill-wave me-2"></i> My Dues
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Member Statistics -->
                    <div class="col-lg-6 mb-4">
                        <div class="card shadow">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">My Statistics</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <div class="card bg-primary text-white shadow">
                                            <div class="card-body">
                                                <div class="row no-gutters align-items-center">
                                                    <div class="col mr-2">
                                                        <div class="text-xs font-weight-bold text-white text-uppercase mb-1">
                                                            Attendance Rate</div>
                                                        <div class="h5 mb-0 font-weight-bold text-white">
                                                            <?php 
                                                            // This would be replaced with actual calculation
                                                            echo "85%";
                                                            ?>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto">
                                                        <i class="fas fa-calendar-check fa-2x text-white-300"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <div class="card bg-success text-white shadow">
                                            <div class="card-body">
                                                <div class="row no-gutters align-items-center">
                                                    <div class="col mr-2">
                                                        <div class="text-xs font-weight-bold text-white text-uppercase mb-1">
                                                            Dues Status</div>
                                                        <div class="h5 mb-0 font-weight-bold text-white">
                                                            <?php 
                                                            // This would be replaced with actual status check
                                                            echo "Paid";
                                                            ?>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto">
                                                        <i class="fas fa-check-circle fa-2x text-white-300"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Upcoming Events -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Upcoming Choir Events</h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>Event</th>
                                        <th>Date</th>
                                        <th>Time</th>
                                        <th>Location</th>
                                        <th>Description</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Sample data - would be replaced with actual events data -->
                                    <tr>
                                        <td>Choir Practice</td>
                                        <td><?php echo date('Y-m-d', strtotime('+2 days')); ?></td>
                                        <td>6:00 PM</td>
                                        <td>Main Church</td>
                                        <td>Regular weekly practice</td>
                                    </tr>
                                    <tr>
                                        <td>Sunday Performance</td>
                                        <td><?php echo date('Y-m-d', strtotime('next Sunday')); ?></td>
                                        <td>9:00 AM</td>
                                        <td>Main Church</td>
                                        <td>Sunday service performance</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                
                <!-- Recent Announcements -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Recent Announcements</h6>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <h5>New Uniform Collection</h5>
                            <p>All members are to collect their new uniforms from the secretary's office by Friday.</p>
                            <small>Posted: <?php echo date('Y-m-d', strtotime('-2 days')); ?></small>
                        </div>
                        <div class="alert alert-warning">
                            <h5>Upcoming Special Event</h5>
                            <p>We will be performing at the annual conference next month. Extra practice sessions will be scheduled.</p>
                            <small>Posted: <?php echo date('Y-m-d', strtotime('-5 days')); ?></small>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Custom scripts -->
    <script src="../assets/js/scripts.js"></script>
</body>
</html>
