<?php
/**
 * My Ratings - Job Portal
 * GHAMECC Job Portal
 */

require_once '../config/database.php';
require_once '../includes/auth.php';

// Check if user is logged in
if (!isLoggedIn()) {
    header('Location: login.php');
    exit();
}

$userId = $_SESSION['user_id'];

// Get ratings received by the user
$ratingsReceived = fetchRows("
    SELECT mr.*, m.first_name, m.last_name, j.title as job_title, j.company_name
    FROM member_ratings mr
    JOIN members m ON mr.rater_id = m.id
    JOIN jobs j ON mr.job_id = j.id
    WHERE mr.rated_id = (SELECT member_id FROM job_portal_users WHERE id = ?)
    ORDER BY mr.created_at DESC
", [$userId]);

// Get ratings given by the user
$ratingsGiven = fetchRows("
    SELECT mr.*, m.first_name, m.last_name, j.title as job_title, j.company_name
    FROM member_ratings mr
    JOIN members m ON mr.rated_id = m.id
    JOIN jobs j ON mr.job_id = j.id
    WHERE mr.rater_id = (SELECT member_id FROM job_portal_users WHERE id = ?)
    ORDER BY mr.created_at DESC
", [$userId]);

// Calculate average rating received
$avgRating = 0;
if (!empty($ratingsReceived)) {
    $totalRating = array_sum(array_column($ratingsReceived, 'rating'));
    $avgRating = round($totalRating / count($ratingsReceived), 1);
}

$pageTitle = "My Ratings";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> - GHAMECC Job Portal</title>
    
    <?php include '../includes/favicon.php'; ?>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .rating-card {
            transition: transform 0.2s;
        }
        .rating-card:hover {
            transform: translateY(-2px);
        }
        .star-rating {
            color: #ffc107;
        }
        .star-rating .far {
            color: #e4e5e9;
        }
        .avg-rating {
            font-size: 2rem;
            font-weight: bold;
        }
        .rating-summary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
    </style>
</head>
<body>
    <?php include 'includes/job-portal-navbar.php'; ?>

    <div class="container mt-4">
        <div class="row">
            <div class="col-12">
                <h2><i class="fas fa-star me-2"></i><?php echo $pageTitle; ?></h2>
                
                <!-- Rating Summary -->
                <div class="card rating-summary mb-4">
                    <div class="card-body text-center">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="avg-rating"><?php echo $avgRating; ?></div>
                                <div class="star-rating mb-2">
                                    <?php for ($i = 1; $i <= 5; $i++): ?>
                                        <i class="<?php echo $i <= $avgRating ? 'fas' : 'far'; ?> fa-star"></i>
                                    <?php endfor; ?>
                                </div>
                                <small>Average Rating</small>
                            </div>
                            <div class="col-md-4">
                                <div class="avg-rating"><?php echo count($ratingsReceived); ?></div>
                                <small>Reviews Received</small>
                            </div>
                            <div class="col-md-4">
                                <div class="avg-rating"><?php echo count($ratingsGiven); ?></div>
                                <small>Reviews Given</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tabs -->
                <ul class="nav nav-tabs" id="ratingTabs" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="received-tab" data-bs-toggle="tab" data-bs-target="#received" type="button" role="tab">
                            <i class="fas fa-inbox me-2"></i>Received (<?php echo count($ratingsReceived); ?>)
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="given-tab" data-bs-toggle="tab" data-bs-target="#given" type="button" role="tab">
                            <i class="fas fa-paper-plane me-2"></i>Given (<?php echo count($ratingsGiven); ?>)
                        </button>
                    </li>
                </ul>

                <div class="tab-content" id="ratingTabContent">
                    <!-- Ratings Received Tab -->
                    <div class="tab-pane fade show active" id="received" role="tabpanel">
                        <div class="mt-4">
                            <?php if (empty($ratingsReceived)): ?>
                                <div class="text-center py-5">
                                    <i class="fas fa-star fa-3x text-muted mb-3"></i>
                                    <h4 class="text-muted">No Ratings Received Yet</h4>
                                    <p class="text-muted">Complete some jobs to start receiving ratings from employers!</p>
                                </div>
                            <?php else: ?>
                                <div class="row">
                                    <?php foreach ($ratingsReceived as $rating): ?>
                                        <div class="col-md-6 col-lg-4 mb-4">
                                            <div class="card rating-card h-100">
                                                <div class="card-body">
                                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                                        <h6 class="card-title mb-0">
                                                            <?php echo htmlspecialchars($rating['first_name'] . ' ' . $rating['last_name']); ?>
                                                        </h6>
                                                        <div class="star-rating">
                                                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                                                <i class="<?php echo $i <= $rating['rating'] ? 'fas' : 'far'; ?> fa-star"></i>
                                                            <?php endfor; ?>
                                                        </div>
                                                    </div>
                                                    
                                                    <p class="card-subtitle text-muted mb-2">
                                                        <i class="fas fa-briefcase me-1"></i>
                                                        <?php echo htmlspecialchars($rating['job_title']); ?>
                                                    </p>
                                                    
                                                    <p class="card-subtitle text-muted mb-3">
                                                        <i class="fas fa-building me-1"></i>
                                                        <?php echo htmlspecialchars($rating['company_name']); ?>
                                                    </p>
                                                    
                                                    <?php if ($rating['review']): ?>
                                                        <p class="card-text">
                                                            <small>"<?php echo htmlspecialchars($rating['review']); ?>"</small>
                                                        </p>
                                                    <?php endif; ?>
                                                    
                                                    <small class="text-muted">
                                                        <?php echo date('M j, Y', strtotime($rating['created_at'])); ?>
                                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Ratings Given Tab -->
                    <div class="tab-pane fade" id="given" role="tabpanel">
                        <div class="mt-4">
                            <?php if (empty($ratingsGiven)): ?>
                                <div class="text-center py-5">
                                    <i class="fas fa-star-half-alt fa-3x text-muted mb-3"></i>
                                    <h4 class="text-muted">No Ratings Given Yet</h4>
                                    <p class="text-muted">Rate members you've worked with to help build trust in our community!</p>
                                </div>
                            <?php else: ?>
                                <div class="row">
                                    <?php foreach ($ratingsGiven as $rating): ?>
                                        <div class="col-md-6 col-lg-4 mb-4">
                                            <div class="card rating-card h-100">
                                                <div class="card-body">
                                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                                        <h6 class="card-title mb-0">
                                                            <?php echo htmlspecialchars($rating['first_name'] . ' ' . $rating['last_name']); ?>
                                                        </h6>
                                                        <div class="star-rating">
                                                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                                                <i class="<?php echo $i <= $rating['rating'] ? 'fas' : 'far'; ?> fa-star"></i>
                                                            <?php endfor; ?>
                                                        </div>
                                                    </div>
                                                    
                                                    <p class="card-subtitle text-muted mb-2">
                                                        <i class="fas fa-briefcase me-1"></i>
                                                        <?php echo htmlspecialchars($rating['job_title']); ?>
                                                    </p>
                                                    
                                                    <p class="card-subtitle text-muted mb-3">
                                                        <i class="fas fa-building me-1"></i>
                                                        <?php echo htmlspecialchars($rating['company_name']); ?>
                                                    </p>
                                                    
                                                    <?php if ($rating['review']): ?>
                                                        <p class="card-text">
                                                            <small>"<?php echo htmlspecialchars($rating['review']); ?>"</small>
                                                        </p>
                                                    <?php endif; ?>
                                                    
                                                    <small class="text-muted">
                                                        <?php echo date('M j, Y', strtotime($rating['created_at'])); ?>
                                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
