<?php
/**
 * Job Portal Logout
 * Handles user logout and session cleanup
 */

session_start();

// Include necessary files
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../config/logger.php';

// Log the logout attempt
if (isset($_SESSION['user_id']) && isset($_SESSION['user_email'])) {
    if (function_exists('logInfo')) {
        logInfo("Job portal user logged out", [
            'user_id' => $_SESSION['user_id'],
            'user_email' => $_SESSION['user_email']
        ]);
    }
}

// Clear all job portal session variables
$jobPortalSessionVars = [
    'user_id',
    'user_email', 
    'user_name',
    'full_name',
    'phone',
    'member_id',
    'user_type',
    'profile_image',
    'last_activity',
    'registration_email',
    'registration_phone',
    'registration_member'
];

foreach ($jobPortalSessionVars as $var) {
    if (isset($_SESSION[$var])) {
        unset($_SESSION[$var]);
    }
}

// Regenerate session ID for security
session_regenerate_id(true);

// Redirect to job portal login page with logout message
header("Location: /ghameccapp/jobs/login.php?message=logged_out");
exit();
?>
