<?php
/**
 * Main Portal Navbar Component
 * GHAMECC Main Portal - Uses users table session data
 */

// Include notifications library and auth functions
require_once __DIR__ . '/../../includes/notifications-library.php';
require_once __DIR__ . '/../../includes/auth.php';

// Get current page for active state
$currentPage = basename($_SERVER['PHP_SELF']);
$currentDir = dirname($_SERVER['PHP_SELF']);

// Check if user is logged in to main portal
function isMainPortalLoggedIn() {
    return isset($_SESSION['user_id']) && isset($_SESSION['full_name']);
}

// Get user information from users table
function getMainPortalUser() {
    if (!isMainPortalLoggedIn()) return null;
    
    $userQuery = "SELECT u.*, r.role_key, r.name as role_name, 
                         s.name as society_name, c.name as circuit_name, d.name as diocese_name
                  FROM users u 
                  LEFT JOIN roles r ON u.role_id = r.id
                  LEFT JOIN societies s ON u.society_id = s.id
                  LEFT JOIN circuits c ON u.circuit_id = c.id
                  LEFT JOIN dioceses d ON u.diocese_id = d.id
                  WHERE u.id = ?";
    return fetchRow($userQuery, [$_SESSION['user_id']]);
}

// Check if user has administrative permissions
function hasAdminPermissions() {
    if (!isMainPortalLoggedIn()) return false;
    
    $user = getMainPortalUser();
    if (!$user) return false;
    
    return in_array($user['role_key'], ['admin', 'diocesan_secretary', 'circuit_secretary', 'society_secretary']) || $user['role_id'] == 1;
}
?>

<nav class="navbar navbar-expand-lg navbar-dark sticky-top" style="background-color: #254094;">
    <div class="container">
        <a class="navbar-brand d-flex align-items-center" href="/ghameccapp/dashboard.php">
            <img src="/ghameccapp/includes/uploads/logo/ghamecclogooriginal.png" alt="GHAMECC" height="40" class="d-inline-block align-text-top me-2">
            <span>GHAMECC Portal</span>
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item">
                    <a class="nav-link <?php echo $currentPage === 'dashboard.php' ? 'active' : ''; ?>" aria-current="page" href="/ghameccapp/dashboard.php">
                        <i class="fas fa-home me-1"></i> Dashboard
                    </a>
                </li>
                
                <?php if (isMainPortalLoggedIn()): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo $currentPage === 'members.php' ? 'active' : ''; ?>" href="/ghameccapp/members/list.php">
                        <i class="fas fa-users me-1"></i> Members
                    </a>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link <?php echo $currentPage === 'societies.php' ? 'active' : ''; ?>" href="/ghameccapp/societies/index.php">
                        <i class="fas fa-church me-1"></i> Societies
                    </a>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link <?php echo $currentPage === 'reports.php' ? 'active' : ''; ?>" href="/ghameccapp/reports/index.php">
                        <i class="fas fa-chart-bar me-1"></i> Reports
                    </a>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link" href="/ghameccapp/jobs/index.php">
                        <i class="fas fa-briefcase me-1"></i> Job Portal
                    </a>
                </li>
                
                <?php if (hasAdminPermissions()): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="adminDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fas fa-cog me-1"></i> Admin
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="adminDropdown">
                        <li>
                            <a class="dropdown-item" href="/ghameccapp/admin/dashboard.php">
                                <i class="fas fa-tachometer-alt me-2"></i> Admin Dashboard
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="/ghameccapp/admin/dioceses.php">
                                <i class="fas fa-map me-2"></i> Dioceses
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="/ghameccapp/admin/settings.php">
                                <i class="fas fa-cogs me-2"></i> Settings
                            </a>
                        </li>
                    </ul>
                </li>
                <?php endif; ?>
                <?php endif; ?>
            </ul>
            
            <div class="d-flex align-items-center">
                <?php if (isMainPortalLoggedIn()): ?>
                    <?php $user = getMainPortalUser(); ?>
                    <!-- Main Portal Notifications Dropdown -->
                    <div class="dropdown">
                        <a class="nav-link position-relative" href="#" id="notificationsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-bell"></i>
                            <?php echo displayNotificationBadge($_SESSION['user_id']); ?>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end notification-dropdown" style="width: 320px; max-height: 400px; overflow-y: auto;" aria-labelledby="notificationsDropdown">
                            <div class="d-flex justify-content-between align-items-center p-3 border-bottom">
                                <h6 class="mb-0">Notifications</h6>
                                <a href="/ghameccapp/notifications.php" class="text-decoration-none small">View All</a>
                            </div>
                            <?php echo displayNotificationDropdownItems($_SESSION['user_id']); ?>
                        </div>
                    </div>
                    
                    <!-- User Dropdown -->
                    <div class="dropdown ms-3">
                        <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <?php if (isset($_SESSION['profile_image']) && !empty($_SESSION['profile_image'])): ?>
                                <img src="/ghameccapp/uploads/profile/<?php echo $_SESSION['profile_image']; ?>" alt="Profile" class="rounded-circle me-2" width="32" height="32">
                            <?php else: ?>
                                <div class="avatar-circle me-2">
                                    <?php
                                    $initials = "";
                                    if (isset($_SESSION['full_name']) && !empty($_SESSION['full_name'])) {
                                        $nameParts = explode(" ", $_SESSION['full_name']);
                                        if (count($nameParts) >= 2) {
                                            $initials = strtoupper(substr($nameParts[0], 0, 1) . substr($nameParts[count($nameParts) - 1], 0, 1));
                                        } else {
                                            $initials = strtoupper(substr($_SESSION['full_name'], 0, 2));
                                        }
                                    } elseif (isset($_SESSION['email']) && !empty($_SESSION['email'])) {
                                        $initials = strtoupper(substr($_SESSION['email'], 0, 2));
                                    } else {
                                        $initials = "U";
                                    }
                                    echo $initials;
                                    ?>
                                </div>
                            <?php endif; ?>
                            <span class="d-none d-md-inline-block">
                                <?php 
                                if (isset($_SESSION['full_name']) && !empty($_SESSION['full_name'])) {
                                    echo htmlspecialchars($_SESSION['full_name']);
                                } elseif (isset($_SESSION['email']) && !empty($_SESSION['email'])) {
                                    echo htmlspecialchars($_SESSION['email']);
                                } else {
                                    echo 'User';
                                }
                                ?>
                            </span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                            <li>
                                <h6 class="dropdown-header">
                                    <?php echo $user ? htmlspecialchars($user['society_name'] ?? 'No Society') : 'User Info'; ?>
                                </h6>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item" href="/ghameccapp/profile.php">
                                    <i class="fas fa-user me-2"></i> My Profile
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="/ghameccapp/change-password.php">
                                    <i class="fas fa-key me-2"></i> Change Password
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="/ghameccapp/jobs/index.php">
                                    <i class="fas fa-briefcase me-2"></i> Job Portal
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item" href="/ghameccapp/logout.php">
                                    <i class="fas fa-sign-out-alt me-2"></i> Logout
                                </a>
                            </li>
                        </ul>
                    </div>
                <?php else: ?>
                    <a href="/ghameccapp/login.php" class="btn btn-outline-light me-2">
                        <i class="fas fa-sign-in-alt me-1"></i> Login
                    </a>
                    <a href="/ghameccapp/register.php" class="btn btn-light">
                        <i class="fas fa-user-plus me-1"></i> Register
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</nav>

<!-- Custom CSS for notifications -->
<style>
.notification-dropdown {
    padding: 0;
}

.notification-item {
    padding: 0.75rem 1rem;
    display: flex;
    align-items: flex-start;
    border-bottom: 1px solid rgba(0,0,0,.05);
    cursor: pointer;
    transition: background-color 0.2s;
}

.notification-item:hover {
    background-color: rgba(0,0,0,.03);
}

.notification-item.unread {
    background-color: rgba(13, 110, 253, 0.05);
    border-left: 3px solid #0d6efd;
}

.avatar-circle {
    width: 32px;
    height: 32px;
    background-color: #007bff;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    font-size: 14px;
    font-weight: 600;
}

.notification-badge {
    position: absolute;
    top: 0;
    right: 0;
    transform: translate(25%, -25%);
    font-size: 0.65rem;
    padding: 0.25rem 0.4rem;
}
</style>
