<?php
require_once '../config/database.php';
require_once '../config/logger.php';

// Create the missing employer account
$email = 'oseibobie@live.com';
$password = 'password123'; // You can change this
$full_name = 'Employer Account';
$phone = '0244000000';
$user_type = 'employer';

// Check if account already exists
$existingUser = fetchRow("SELECT id FROM job_portal_users WHERE email = ?", [$email]);

if ($existingUser) {
    echo "<h2>Account Already Exists</h2>";
    echo "<p>User with email <strong>$email</strong> already exists with ID: " . $existingUser['id'] . "</p>";
} else {
    // Hash password
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
    
    // Insert new user
    $insertQuery = "INSERT INTO job_portal_users (email, password, full_name, phone, user_type, status, created_at) 
                   VALUES (?, ?, ?, ?, ?, 'active', NOW())";
    
    $result = executeQuery($insertQuery, [
        $email,
        $hashedPassword,
        $full_name,
        $phone,
        $user_type
    ]);
    
    if ($result) {
        echo "<h2>✅ Account Created Successfully!</h2>";
        echo "<div style='background: #d4edda; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
        echo "<h3>New Employer Account Details:</h3>";
        echo "<p><strong>Email:</strong> $email</p>";
        echo "<p><strong>Password:</strong> $password</p>";
        echo "<p><strong>User Type:</strong> $user_type</p>";
        echo "<p><strong>Status:</strong> active</p>";
        echo "</div>";
        
        echo "<h3>You can now login with:</h3>";
        echo "<ul>";
        echo "<li>Email: <strong>$email</strong></li>";
        echo "<li>Password: <strong>$password</strong></li>";
        echo "</ul>";
        
        logInfo("Employer account created successfully", [
            'email' => $email,
            'user_type' => $user_type
        ]);
    } else {
        echo "<h2>❌ Failed to Create Account</h2>";
        echo "<p>There was an error creating the account. Please check the logs.</p>";
        
        logError("Failed to create employer account", [
            'email' => $email,
            'error' => 'Database insertion failed'
        ]);
    }
}

// Show all current users for reference
echo "<h3>Current Job Portal Users:</h3>";
$users = fetchRows("SELECT id, email, full_name, user_type, status FROM job_portal_users ORDER BY user_type, email");

echo "<table border='1' style='border-collapse: collapse; width: 100%; margin: 20px 0;'>";
echo "<tr style='background: #f0f0f0;'>";
echo "<th style='padding: 10px;'>ID</th>";
echo "<th style='padding: 10px;'>Email</th>";
echo "<th style='padding: 10px;'>Full Name</th>";
echo "<th style='padding: 10px;'>User Type</th>";
echo "<th style='padding: 10px;'>Status</th>";
echo "</tr>";

foreach ($users as $user) {
    $rowColor = $user['user_type'] === 'employer' ? '#ffe6e6' : '#e6f3ff';
    echo "<tr style='background: $rowColor;'>";
    echo "<td style='padding: 8px;'>" . htmlspecialchars($user['id']) . "</td>";
    echo "<td style='padding: 8px; font-weight: bold;'>" . htmlspecialchars($user['email']) . "</td>";
    echo "<td style='padding: 8px;'>" . htmlspecialchars($user['full_name']) . "</td>";
    echo "<td style='padding: 8px;'>" . htmlspecialchars($user['user_type']) . "</td>";
    echo "<td style='padding: 8px;'>" . htmlspecialchars($user['status']) . "</td>";
    echo "</tr>";
}
echo "</table>";
?>
