<?php
/**
 * GHAMECC - Ghana Methodist Church Choir Management Platform
 * Landing Page / Dashboard Router
 */

// Include authentication functions
require_once 'includes/auth.php';

// Check if user is logged in
if (isLoggedIn()) {
    // User is authenticated - show dashboard
    
    // Get user information
    $userId = $_SESSION['user_id'];
    $userFullName = $_SESSION['full_name'] ?? $_SESSION['email'] ?? 'User';

    // Create directory for dashboard widgets if it doesn't exist
    $widgetsDir = __DIR__ . '/includes/dashboard_widgets';
    if (!file_exists($widgetsDir)) {
        mkdir($widgetsDir, 0777, true);
    }

    // Set base path for includes
    $basePath = '.';
    
    // Include the dashboard view
    include 'dashboard.php';
    
} else {
    // User is not authenticated - show landing page
    
    // Set page title
    $pageTitle = "Ghana Methodist Church Choir - Connexion Platform";
    
    // Load approved ads for landing page
    $ads = [];
    if (function_exists('fetchRows')) {
        $ads = fetchRows("SELECT * FROM ads WHERE status = 'approved' AND (starts_at IS NULL OR starts_at <= NOW()) AND (ends_at IS NULL OR ends_at >= NOW()) ORDER BY created_at DESC LIMIT 10");
    }
    ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?></title>
    
    <?php include 'includes/favicon.php'; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #1e40af;
            --secondary-color: #1e40af;
            --accent-color: #fbbf24;
            --text-dark: #1f2937;
            --text-light: #6b7280;
            --bg-light: #f9fafb;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
        }
        
        .hero-section {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 100px 0;
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/><circle cx="50" cy="10" r="0.5" fill="white" opacity="0.1"/><circle cx="10" cy="60" r="0.5" fill="white" opacity="0.1"/><circle cx="90" cy="40" r="0.5" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
            opacity: 0.3;
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
        }
        
        .hero-logo {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            border: 4px solid rgba(255, 255, 255, 0.3);
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
            object-fit: cover;
        }
        
        .hero-title {
            font-size: 3.5rem;
            font-weight: 700;
            margin-bottom: 1.5rem;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }
        
        .hero-subtitle {
            font-size: 1.5rem;
            font-weight: 300;
            margin-bottom: 2rem;
            opacity: 0.9;
        }
        
        .greeting-badge {
            background: var(--accent-color);
            color: var(--primary-color);
            padding: 0.5rem 1.5rem;
            border-radius: 50px;
            font-weight: 600;
            font-size: 1.1rem;
            display: inline-block;
            margin-bottom: 2rem;
            box-shadow: 0 4px 15px rgba(251, 191, 36, 0.3);
        }
        
        .portal-card {
            background: white;
            border-radius: 20px;
            padding: 2.5rem;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            height: 100%;
            border: 1px solid rgba(255,255,255,0.2);
        }
        
        .portal-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 60px rgba(0,0,0,0.15);
        }
        
        .portal-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1.5rem;
            color: white;
            font-size: 2rem;
        }
        
        .portal-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 1rem;
            color: var(--primary-color);
        }
        
        .portal-description {
            color: var(--text-light);
            margin-bottom: 2rem;
            line-height: 1.6;
        }
        
        .portal-btn {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 0.75rem 2rem;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
            display: inline-block;
            border: none;
        }
        
        .portal-btn:hover {
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(30, 58, 138, 0.3);
        }
        
        .feature-section {
            padding: 100px 0;
            background: var(--bg-light);
        }
        
        .feature-card {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            text-align: center;
            box-shadow: 0 5px 20px rgba(0,0,0,0.08);
            transition: all 0.3s ease;
            height: 100%;
        }
        
        .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.12);
        }
        
        .feature-icon {
            width: 60px;
            height: 60px;
            background: var(--accent-color);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            color: var(--primary-color);
            font-size: 1.5rem;
        }
        
        .feature-title {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 1rem;
            color: var(--primary-color);
        }
        
        .section-title {
            font-size: 2.5rem;
            font-weight: 700;
            text-align: center;
            margin-bottom: 3rem;
            color: var(--primary-color);
        }
        
        .about-section {
            padding: 100px 0;
        }
        
        .about-content {
            background: white;
            border-radius: 20px;
            padding: 3rem;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        }
        
        .footer {
            background: var(--primary-color);
            color: white;
            padding: 3rem 0 2rem;
            text-align: center;
        }
        
        .footer-links {
            margin-bottom: 2rem;
        }
        
        .footer-links a {
            color: white;
            text-decoration: none;
            margin: 0 1rem;
            opacity: 0.8;
            transition: opacity 0.3s ease;
        }
        
        .footer-links a:hover {
            opacity: 1;
            color: var(--accent-color);
        }
        
        @media (max-width: 768px) {
            .hero-logo {
                width: 100px;
                height: 100px;
            }
            
            .hero-title {
                font-size: 2.5rem;
            }
            
            .hero-subtitle {
                font-size: 1.2rem;
            }
            
            .portal-card {
                padding: 2rem;
                margin-bottom: 2rem;
            }
            
            .section-title {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10 text-center hero-content">
                    <img src="uploads/logo/ghamecclogooriginal.png" alt="GHAMECC Logo" class="hero-logo">
                    <div class="greeting-badge">
                        <i class="fas fa-hands-praying me-2"></i>
                        SERVICE TO GOD
                    </div>
                    <h1 class="hero-title">Ghana Methodist Church Choir</h1>
                    <p class="hero-subtitle">Connexion • Dioceses • Circuits • Societies</p>
                    <p class="lead mb-4">
                        Welcome to the official platform of the Ghana Methodist Church Choir (GHAMECC).
                        We are a community of believers united in worship, serving God through the gift of music 
                        and fostering spiritual growth across our Connexion, dioceses, circuits, and societies.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Member Adverts Listing -->
    <?php if (!empty($ads)): ?>
    <section class="py-4" style="background:#fff;">
        <div class="container">
            <h2 class="section-title mb-4">Member Adverts</h2>
            <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-4 g-3">
                <?php foreach ($ads as $ad): ?>
                    <?php 
                        $descText = isset($ad['description']) ? strip_tags($ad['description']) : '';
                        $short = strlen($descText) > 110 ? substr($descText, 0, 110) . '...' : $descText;
                    ?>
                    <div class="col">
                        <a href="ads/view.php?id=<?php echo (int)$ad['id']; ?>" class="text-decoration-none text-reset">
                            <div class="card h-100 shadow-sm">
                                <div class="ratio ratio-4x3">
                                    <img src="uploads/ads/<?php echo htmlspecialchars($ad['image_path']); ?>" class="card-img-top" alt="<?php echo htmlspecialchars($ad['title']); ?>" style="object-fit:cover;">
                                </div>
                                <div class="card-body">
                                    <?php if ((float)$ad['price'] > 0): ?>
                                        <div class="text-success fw-bold mb-1">GHS <?php echo number_format((float)$ad['price'], 2); ?></div>
                                    <?php endif; ?>
                                    <h6 class="card-title mb-1"><?php echo htmlspecialchars($ad['title']); ?></h6>
                                    <?php if ($short): ?><p class="card-text text-muted small mb-0"><?php echo htmlspecialchars($short); ?></p><?php endif; ?>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="d-flex justify-content-center gap-2 mt-3">
                <a href="ads/list.php" class="btn btn-outline-primary">
                    <i class="fas fa-list me-2"></i>View all adverts
                </a>
                <a href="ads/submit.php" class="btn btn-primary">
                    <i class="fas fa-bullhorn me-2"></i>Advertise with us
                </a>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <!-- Portal Access Section -->
    <section class="py-5">
        <div class="container">
            <div class="row justify-content-center g-4 mt-5">
                <div class="col-lg-5 col-md-6">
                    <div class="portal-card">
                        <div class="portal-icon">
                            <i class="fas fa-users-cog"></i>
                        </div>
                        <h3 class="portal-title">Management Portal</h3>
                        <p class="portal-description">
                            Access the comprehensive choir management system for Connexion, dioceses, circuits, and societies administration. 
                            Manage memberships, track attendance, handle finances, generate reports, and coordinate conferences.
                        </p>
                        <a href="login.php" class="portal-btn">
                            <i class="fas fa-sign-in-alt me-2"></i>
                            Access Management Portal
                        </a>
                    </div>
                </div>
                <div class="col-lg-5 col-md-6">
                    <div class="portal-card">
                        <div class="portal-icon">
                            <i class="fas fa-briefcase"></i>
                        </div>
                        <h3 class="portal-title">Jobs Portal</h3>
                        <p class="portal-description">
                            Explore career opportunities within the Ghana Methodist Church community. 
                            Find job openings, submit applications, and connect with potential employers 
                            in our faith-based professional network.
                        </p>
                        <a href="jobs/" class="portal-btn">
                            <i class="fas fa-search me-2"></i>
                            Browse Job Opportunities
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- About Platform Section -->
    <section class="about-section">
        <div class="container">
            <h2 class="section-title">About Our Platform</h2>
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="about-content">
                        <div class="row g-4">
                            <div class="col-md-6">
                                <h4 class="text-primary mb-3">
                                    <i class="fas fa-church me-2"></i>
                                    Our Mission
                                </h4>
                                <p>
                                    The GHAMECC platform serves as the digital backbone for the Ghana Methodist Church Choir 
                                    across the Connexion, facilitating seamless communication, efficient management, and spiritual 
                                    growth across all our communities.
                                </p>
                            </div>
                            <div class="col-md-6">
                                <h4 class="text-primary mb-3">
                                    <i class="fas fa-music me-2"></i>
                                    Our Heritage
                                </h4>
                                <p>
                                    With a rich tradition of worship through music, our choirs have been pillars of faith 
                                    in the Methodist community, bringing congregations together in praise and worship 
                                    while nurturing musical talents for God's glory.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="feature-section">
        <div class="container">
            <h2 class="section-title">Platform Features</h2>
            <div class="row g-4">
                <div class="col-lg-4 col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-sitemap"></i>
                        </div>
                        <h4 class="feature-title">Organizational Management</h4>
                        <p>
                            Comprehensive management system for the Connexion, dioceses, circuits, and societies. 
                            Streamlined hierarchy management with role-based access control and 
                            administrative oversight capabilities.
                        </p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <h4 class="feature-title">Membership Management</h4>
                        <p>
                            Complete member registration, profile management, and tracking system. 
                            Monitor member participation, maintain contact information, and 
                            facilitate communication across all organizational levels.
                        </p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-calendar-check"></i>
                        </div>
                        <h4 class="feature-title">Conference Coordination</h4>
                        <p>
                            Organize and manage choir conferences, workshops, and events. 
                            Handle registrations, accommodation bookings, delegate management, 
                            and comprehensive event coordination tools.
                        </p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <h4 class="feature-title">Reporting System</h4>
                        <p>
                            Structured reporting workflow from societies to circuits, and circuits to diocese. 
                            Track activities, generate insights, monitor progress, and maintain 
                            transparent communication channels.
                        </p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                        <h4 class="feature-title">Financial Management</h4>
                        <p>
                            Comprehensive financial tracking and management system. 
                            Monitor income, expenses, generate financial reports, and 
                            maintain transparent financial records across all levels.
                        </p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-user-check"></i>
                        </div>
                        <h4 class="feature-title">Attendance Tracking</h4>
                        <p>
                            Digital attendance management for rehearsals, services, and events. 
                            Generate attendance reports, track participation patterns, and 
                            maintain accurate records for all choir activities.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Organizational Structure Section -->
    <section class="py-5">
        <div class="container">
            <h2 class="section-title">Our Structure</h2>
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="about-content">
                        <div class="row g-4 text-center">
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <i class="fas fa-globe fa-3x text-primary mb-3"></i>
                                    <h4 class="text-primary">Connexion Level</h4>
                                </div>
                                <p>
                                    The Connexion provides overall direction and unity across all dioceses, 
                                    setting shared vision, standards, and coordination for mission and ministry.
                                </p>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <i class="fas fa-building fa-3x text-primary mb-3"></i>
                                    <h4 class="text-primary">Diocese Level</h4>
                                </div>
                                <p>
                                    Dioceses oversee circuits within their jurisdiction, providing strategic direction, 
                                    resource allocation, and policy implementation across their areas.
                                </p>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <i class="fas fa-project-diagram fa-3x text-primary mb-3"></i>
                                    <h4 class="text-primary">Circuit Level</h4>
                                </div>
                                <p>
                                    Circuits coordinate multiple societies, facilitating communication, organizing joint activities, 
                                    and reporting to the diocese on collective progress and needs.
                                </p>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <i class="fas fa-users fa-3x text-primary mb-3"></i>
                                    <h4 class="text-primary">Society Level</h4>
                                </div>
                                <p>
                                    Societies form the foundation of our organization, where members participate in worship, fellowship, 
                                    and community service while developing their musical gifts.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-links">
                <a href="login.php">Management Portal</a>
                <a href="jobs/">Jobs Portal</a>
                <a href="#about">About Us</a>
                <a href="#contact">Contact</a>
            </div>
            <div class="row">
                <div class="col-md-6 text-md-start text-center">
                    <p class="mb-0">&copy; <?php echo date('Y'); ?> Ghana Methodist Church Choir - Connexion</p>
                </div>
                <div class="col-md-6 text-md-end text-center">
                    <p class="mb-0">
                        <i class="fas fa-heart text-danger me-1"></i>
                        Built with faith and dedication
                    </p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Smooth scrolling and animations -->
    <script>
        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Add fade-in animation on scroll
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Observe feature cards and portal cards
        document.querySelectorAll('.feature-card, .portal-card').forEach(card => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(30px)';
            card.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
            observer.observe(card);
        });
    </script>
</body>
</html>

<?php
}
?>
