<?php
/**
 * Navbar Component
 * GHAMECC Choir Management Platform
 */

// Include notifications system
require_once __DIR__ . '/notifications.php';
?>

<nav class="navbar navbar-expand-lg navbar-dark sticky-top" style="background-color: #254094;">
    <div class="container-fluid">
        <a class="navbar-brand d-flex align-items-center" href="<?php echo $basePath; ?>/index.php">
            <img src="<?php echo $basePath; ?>/includes/uploads/logo/ghamecclogooriginal.png" alt="GHAMECC" height="40" class="d-inline-block align-text-top me-2">
            <span>GHAMECC Choir</span>
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'index.php' ? 'active' : ''; ?>" aria-current="page" href="<?php echo $basePath; ?>/index.php">
                        <i class="fas fa-home me-1"></i> Home
                    </a>
                </li>
                
                <!-- Reports Menu with Notification Badge -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle position-relative <?php echo dirname($_SERVER['PHP_SELF']) === $basePath . '/reports' ? 'active' : ''; ?>" href="#" id="reportsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fas fa-file-alt me-1"></i> Reports
                        <?php echo displayReportNotificationBadge(); ?>
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="reportsDropdown">
                        <li>
                            <a class="dropdown-item" href="<?php echo $basePath; ?>/reports/submit.php">
                                <i class="fas fa-paper-plane me-2"></i> Submit Report
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item position-relative" href="<?php echo $basePath; ?>/reports/received.php">
                                <i class="fas fa-inbox me-2"></i> Received Reports
                                <?php echo displayReportNotificationBadge(); ?>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?php echo $basePath; ?>/reports/sent.php">
                                <i class="fas fa-share-square me-2"></i> Sent Reports
                            </a>
                        </li>
                    </ul>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'members.php' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/members/index.php">
                        <i class="fas fa-users me-1"></i> Members
                    </a>
                </li>
                
                <?php
                // Show Jobs menu for users with approval permissions
                if (isset($_SESSION['user_id']) && hasRole(['admin', 'society_secretary', 'choirmaster', 'diocesan_secretary', 'diocese_chairman'])) {
                ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'job-approval.php' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/job-approval.php">
                        <i class="fas fa-briefcase me-1"></i> Jobs
                        <?php
                        // Show pending jobs count badge
                        $pendingJobsCount = 0;
                        if (isset($conn)) {
                            $countQuery = "SELECT COUNT(*) as count FROM jobs WHERE status = 'pending'";
                            
                            // Filter based on user permissions - diocese roles see all jobs
                            if (!hasRole(['admin', 'diocesan_secretary', 'diocese_chairman'])) {
                                if (isset($_SESSION['society_id']) && !empty($_SESSION['society_id'])) {
                                    $countQuery .= " AND society_id = " . (int)$_SESSION['society_id'];
                                } elseif (isset($_SESSION['circuit_id']) && !empty($_SESSION['circuit_id'])) {
                                    $countQuery .= " AND society_id IN (SELECT id FROM societies WHERE circuit_id = " . (int)$_SESSION['circuit_id'] . ")";
                                }
                            }
                            
                            $countResult = fetchRow($countQuery);
                            if ($countResult) {
                                $pendingJobsCount = (int)$countResult['count'];
                            }
                        }
                        
                        if ($pendingJobsCount > 0) {
                            echo '<span class="badge bg-warning text-dark ms-1">' . $pendingJobsCount . '</span>';
                        }
                        ?>
                    </a>
                </li>
                <?php } ?>

                <!-- Adverts: Diocese + Connexion roles only -->
                <?php if (isset($_SESSION['user_id']) && hasRole(['admin', 'diocesan_chairman', 'diocese_chairman', 'diocesan_secretary', 'diocesan_treasurer', 'diocesan_dom', 'diocesan_music_director'])): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) === 'submit.php' && strpos(str_replace('\\','/', dirname($_SERVER['PHP_SELF'])), '/ads') !== false) ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/ads/submit.php">
                        <i class="fas fa-bullhorn me-1"></i> Adverts
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($_SESSION['user_id']) && hasRole(['admin', 'diocesan_chairman', 'diocese_chairman', 'diocesan_secretary', 'diocesan_treasurer', 'diocesan_dom', 'diocesan_music_director'])): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) === 'manage.php' && strpos(str_replace('\\','/', dirname($_SERVER['PHP_SELF'])), '/ads') !== false) ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/ads/manage.php">
                        <i class="fas fa-check-circle me-1"></i> Manage Adverts
                    </a>
                </li>
                <?php endif; ?>
            </ul>
            
            <div class="d-flex align-items-center">
                <!-- Notifications Dropdown -->
                <?php echo displayNotificationDropdown(); ?>
                
                <!-- User Dropdown -->
                <div class="dropdown ms-3">
                    <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <?php if (isset($_SESSION['profile_image']) && !empty($_SESSION['profile_image'])): ?>
                            <img src="<?php echo $basePath; ?>/uploads/profile/<?php echo $_SESSION['profile_image']; ?>" alt="Profile" class="rounded-circle me-2" width="32" height="32">
                        <?php else: ?>
                            <div class="avatar-circle me-2">
                                <?php
                                $initials = "";
                                if (isset($_SESSION['full_name'])) {
                                    $nameParts = explode(" ", $_SESSION['full_name']);
                                    if (count($nameParts) >= 2) {
                                        $initials = strtoupper(substr($nameParts[0], 0, 1) . substr($nameParts[count($nameParts) - 1], 0, 1));
                                    } else {
                                        $initials = strtoupper(substr($_SESSION['full_name'], 0, 2));
                                    }
                                } elseif (isset($_SESSION['email'])) {
                                    $initials = strtoupper(substr($_SESSION['email'], 0, 2));
                                }
                                echo $initials;
                                ?>
                            </div>
                        <?php endif; ?>
                        <span class="d-none d-md-inline-block">
                            <?php echo isset($_SESSION['full_name']) ? htmlspecialchars($_SESSION['full_name']) : (isset($_SESSION['email']) ? htmlspecialchars($_SESSION['email']) : 'User'); ?>
                        </span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                        <li>
                            <a class="dropdown-item" href="<?php echo $basePath; ?>/profile.php">
                                <i class="fas fa-user me-2"></i> Profile
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?php echo $basePath; ?>/change-password.php">
                                <i class="fas fa-key me-2"></i> Change Password
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item" href="<?php echo $basePath; ?>/logout.php">
                                <i class="fas fa-sign-out-alt me-2"></i> Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</nav>

<!-- Custom CSS for notifications -->
<style>
.notification-dropdown {
    padding: 0;
}

.notification-item {
    padding: 0.75rem 1rem;
    display: flex;
    align-items: flex-start;
    border-bottom: 1px solid rgba(0,0,0,.05);
}

.notification-icon {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    margin-right: 12px;
    flex-shrink: 0;
}

.notification-content {
    flex-grow: 1;
}

.notification-title {
    font-weight: 600;
    font-size: 0.9rem;
    margin-bottom: 2px;
}

.notification-text {
    font-size: 0.85rem;
    color: #6c757d;
    margin-bottom: 2px;
}

.notification-time {
    font-size: 0.75rem;
    color: #adb5bd;
}

.avatar-circle {
    width: 32px;
    height: 32px;
    background-color: #007bff;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    font-size: 14px;
    font-weight: 600;
}

.avatar-circle-sm {
    width: 36px;
    height: 36px;
    background-color: #007bff;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    font-size: 14px;
    font-weight: 600;
}
</style>
