<?php
/**
 * Debug Script - Display Current User Role Information
 * GHAMECC Choir Management Platform
 */

// Include authentication functions
require_once 'includes/auth.php';

// Require login
requireLogin();

// Set page title
$pageTitle = "Debug User Role Information";

// Include header
include 'includes/header.php';
?>

<body>
    <!-- Navigation -->
    <?php include 'includes/navbar.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Main Content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Debug User Role Information</h1>
                </div>
                
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Current User Session Information</h6>
                    </div>
                    <div class="card-body">
                        <h5>Session Variables:</h5>
                        <pre><?php print_r($_SESSION); ?></pre>
                        
                        <hr>
                        
                        <h5>Role Checks:</h5>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Role</th>
                                    <th>Has Role?</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>admin</td>
                                    <td><?php echo hasRole('admin') ? 'Yes' : 'No'; ?></td>
                                </tr>
                                <tr>
                                    <td>choirmaster</td>
                                    <td><?php echo hasRole('choirmaster') ? 'Yes' : 'No'; ?></td>
                                </tr>
                                <tr>
                                    <td>society_secretary</td>
                                    <td><?php echo hasRole('society_secretary') ? 'Yes' : 'No'; ?></td>
                                </tr>
                                <tr>
                                    <td>society_treasurer</td>
                                    <td><?php echo hasRole('society_treasurer') ? 'Yes' : 'No'; ?></td>
                                </tr>
                                <tr>
                                    <td>Any society role</td>
                                    <td><?php echo hasRole(['choirmaster', 'society_secretary', 'society_treasurer']) ? 'Yes' : 'No'; ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
