-- Approval history for ads
CREATE TABLE IF NOT EXISTS `ad_approval_history` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `ad_id` INT NOT NULL,
  `action` ENUM('approved','rejected') NOT NULL,
  `note` VARCHAR(255) DEFAULT NULL,
  `by_user_id` INT NOT NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  INDEX `idx_ad_approval_ad` (`ad_id`),
  INDEX `idx_ad_approval_user` (`by_user_id`),
  CONSTRAINT `fk_ad_approval_ad` FOREIGN KEY (`ad_id`) REFERENCES `ads`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
