<?php
/**
 * Keep Alive Endpoint
 * Refreshes the user's session to prevent timeout during active use
 * GHAMECC Choir Management Platform
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in
if (isset($_SESSION['user_id'])) {
    // Update last activity timestamp
    $_SESSION['last_activity'] = time();
    
    // Log session refresh if logging is available
    if (function_exists('logInfo')) {
        logInfo("Session refreshed via keep-alive", [
            'user_id' => $_SESSION['user_id'],
            'email' => $_SESSION['email'] ?? 'unknown'
        ]);
    }
    
    // Return success response
    header('Content-Type: application/json');
    echo json_encode(['status' => 'success', 'message' => 'Session refreshed']);
} else {
    // User is not logged in
    header('HTTP/1.1 401 Unauthorized');
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'Not logged in']);
}
