<?php
/**
 * AJAX handler to fetch societies based on circuit ID
 * GHAMECC Choir Management Platform
 */

// Include database configuration
require_once '../config/database.php';

// Set content type to JSON
header('Content-Type: application/json');

// Check if circuit_id is provided
if (!isset($_GET['circuit_id']) || empty($_GET['circuit_id'])) {
    echo json_encode([]);
    exit;
}

// Get circuit ID
$circuitId = (int)$_GET['circuit_id'];

// Fetch societies for the selected circuit
$societies = fetchRows(
    "SELECT id, name FROM societies WHERE circuit_id = ? ORDER BY name",
    [$circuitId]
);

// Return societies as JSON
echo json_encode($societies);
