<?php
/**
 * Admin Dashboard
 * GHAMECC Choir Management Platform
 */

// Include authentication functions
require_once '../includes/auth.php';

// Require login and admin role
requireLogin();
requireRole('admin');

// Get user information
$userId = $_SESSION['user_id'];
$userFullName = $_SESSION['full_name'] ?? $_SESSION['email'] ?? 'User';

// Set base path for includes
$basePath = '..';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - GHAMECC Choir Management</title>
    
    <?php include '../includes/favicon.php'; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Custom CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <!-- Navigation -->
    <?php include '../includes/navbar.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include '../includes/sidebar.php'; ?>
            
            <!-- Main Content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Admin Dashboard</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <button type="button" class="btn btn-sm btn-outline-secondary">Share</button>
                            <button type="button" class="btn btn-sm btn-outline-secondary">Export</button>
                        </div>
                    </div>
                </div>
                
                <!-- Welcome Card -->
                <div class="card shadow mb-4">
                    <div class="card-body">
                        <h4>Welcome to the Admin Dashboard</h4>
                        <p>As an administrator, you have full access to all system features and settings.</p>
                    </div>
                </div>
                
                <div class="row">
                    <!-- Admin Quick Links -->
                    <div class="col-lg-6 mb-4">
                        <div class="card shadow">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">Admin Quick Links</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <a href="../users/list.php" class="btn btn-primary btn-block w-100">
                                            <i class="fas fa-users me-2"></i> Manage Users
                                        </a>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <a href="../roles/list.php" class="btn btn-secondary btn-block w-100">
                                            <i class="fas fa-user-tag me-2"></i> Manage Roles
                                        </a>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <a href="../settings/general.php" class="btn btn-info btn-block w-100">
                                            <i class="fas fa-cog me-2"></i> System Settings
                                        </a>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <a href="../logs/view.php" class="btn btn-warning btn-block w-100">
                                            <i class="fas fa-clipboard-list me-2"></i> System Logs
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- System Stats -->
                    <div class="col-lg-6 mb-4">
                        <div class="card shadow">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">System Statistics</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <div class="card bg-primary text-white shadow">
                                            <div class="card-body">
                                                <div class="row no-gutters align-items-center">
                                                    <div class="col mr-2">
                                                        <div class="text-xs font-weight-bold text-white text-uppercase mb-1">
                                                            Total Users</div>
                                                        <div class="h5 mb-0 font-weight-bold text-white">
                                                            <?php 
                                                            require_once '../config/database.php';
                                                            $userCount = fetchRow("SELECT COUNT(*) as count FROM users");
                                                            echo $userCount ? $userCount['count'] : 0;
                                                            ?>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto">
                                                        <i class="fas fa-users fa-2x text-white-300"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <div class="card bg-success text-white shadow">
                                            <div class="card-body">
                                                <div class="row no-gutters align-items-center">
                                                    <div class="col mr-2">
                                                        <div class="text-xs font-weight-bold text-white text-uppercase mb-1">
                                                            Active Members</div>
                                                        <div class="h5 mb-0 font-weight-bold text-white">
                                                            <?php 
                                                            $memberCount = fetchRow("SELECT COUNT(*) as count FROM members");
                                                            echo $memberCount ? $memberCount['count'] : 0;
                                                            ?>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto">
                                                        <i class="fas fa-user-check fa-2x text-white-300"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Recent Activity -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Recent System Activity</h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>User</th>
                                        <th>Action</th>
                                        <th>Details</th>
                                        <th>Date/Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Sample data - would be replaced with actual log data -->
                                    <tr>
                                        <td>System</td>
                                        <td>Login</td>
                                        <td>Admin user logged in</td>
                                        <td><?php echo date('Y-m-d H:i:s'); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Custom scripts -->
    <script src="../assets/js/scripts.js"></script>
</body>
</html>
